/*******************************************************************************
*   touch.h
*   Atmel Corporation:  http://www.atmel.com \n
*   Support email:  touch@atmel.com
******************************************************************************/
/*  License
*   Copyright (c) 2010, Atmel Corporation All rights reserved.
*
*   Redistribution and use in source and binary forms, with or without
*   modification, are permitted provided that the following conditions are met:
*
*   1. Redistributions of source code must retain the above copyright notice,
*   this list of conditions and the following disclaimer.
*
*   2. Redistributions in binary form must reproduce the above copyright notice,
*   this list of conditions and the following disclaimer in the documentation
*   and/or other materials provided with the distribution.
*
*   3. The name of ATMEL may not be used to endorse or promote products derived
*   from this software without specific prior written permission.
*
*   THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
*   WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
*   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
*   SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
*   INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
*   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
*   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
*   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
*   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*  This is an automatically generated file. Do not modify the contents manually.
    Instead, use the Project Builder Wizard to make changes to the design.
*/
#define F_CPU 8000000UL

#include <inttypes.h>
#include <avr/io.h>
#include <avr/interrupt.h>
#include <stdio.h>
#include <avr/eeprom.h>

#define __delay_cycles(n)     __builtin_avr_delay_cycles(n)
#define __enable_interrupt()  sei()

#include "touch_api.h"
#include "touch.h"
#include "uart.h"
#include "util/delay.h"

/*----------------------------------------------------------------------------
                                    macros
----------------------------------------------------------------------------*/

#define GET_SENSOR_STATE(SENSOR_NUMBER) qt_measure_data.qt_touch_status.sensor_states[(SENSOR_NUMBER/8)] & (1 << (SENSOR_NUMBER % 8))
#define GET_ROTOR_SLIDER_POSITION(ROTOR_SLIDER_NUMBER) qt_measure_data.qt_touch_status.rotor_slider_values[ROTOR_SLIDER_NUMBER]

#define QT_NUM_CHANNELS 8

/*----------------------------------------------------------------------------
                                prototypes
----------------------------------------------------------------------------*/
extern void touch_measure();
extern void touch_init( void );
extern void init_system( void );
extern void init_timer_isr(void);
extern void set_timer_period(uint16_t);
void sendMessages();

/*----------------------------------------------------------------------------
                                    macros
----------------------------------------------------------------------------*/
/* Send data every 1s */
#define ST 5

/* ID for indicating tempo and volume */
#define TEMPO_ID 0x48
#define VOLUME_ID 0x49

/* Switch values to send tempo and volume */
#define SEND_TEMPO 0
#define SEND_VOLUME 1
/*----------------------------------------------------------------------------
                                global variables
----------------------------------------------------------------------------*/
/* Timer period in msec. */
uint16_t qt_measurement_period_msec = QT_MEASUREMENT_PERIOD_MS;
uint16_t time_ms_inc=0;

/* Initialize the slider read value */
uint8_t sensor_read = 0x00;

/* Initialize volume and tempo */
uint8_t volume = 0x0F;
uint8_t tempo = 0xEF;

/* Switch is set to send Tempo first. Alternates between tempo and volume */
uint8_t send_switch = SEND_TEMPO;

/* State variables to switch LEDs */
volatile uint8_t state=1;
volatile uint8_t state1 = 1;

volatile uint8_t count1;
volatile uint8_t count2;

int flag1=0; 
int flag2=0;
char tempo_led_old=0;

/* Number of LEDs to be on for Tempo and Volume */
extern volatile uint8_t tempo_leds;
extern volatile uint8_t vol_leds;

/* flag set by timer ISR when it's time to measure touch */
volatile uint8_t time_to_measure_touch = 0u;

/* current time, set by timer ISR */
volatile uint16_t current_time_ms_touch = 0u;

/* Periodic interval at which data is sent */
volatile uint16_t send_time = ST;

/* Stores LED control inputs */
char ledA[16];
char ledB[8];

char sum=0;

/*============================================================================
Name    :   main
------------------------------------------------------------------------------
Purpose :   main code entry point
============================================================================*/

int main (void)
{
	 
	// SET LED A
	ledA[0]=0b00000000;
	ledA[1]=0b00001000;
	ledA[2]=0b00000100;
	ledA[3]=0b00001100;
	ledA[4]=0b01000000;
	ledA[5]=0b01000100;
	ledA[6]=0b01001000;
	ledA[7]=0b01001100;
	ledA[8]=0b01100100;
	ledA[9]=0b01100000;
	ledA[10]=0b01101100;
	ledA[11]=0b01101000;
	ledA[12]=0b00100100;
	ledA[13]=0b00100000;
	ledA[14]=0b00101100;
	ledA[15]=0b00101000;
	 
	 // SET LED B
	 ledB[0]=0b00010011;
	 ledB[1]=0b00010010;
	 ledB[2]=0b00000011;
	 ledB[3]=0b00000010;
	 ledB[4]=0b00010001;
	 ledB[5]=0b00000001;
	 ledB[6]=0b00010000;
	 ledB[7]=0b00000000;
	 
	 // Make C output port to send control inputs to LEDs
	 DDRC = 0xFF;
	 // Made PortD an output port to control the Strobe input of the LEDs
	 DDRD = 0xFF;
	 // Make Strobe High
 	 PORTD = 0xFF;
	 
	 uint8_t tempo_prev = 0;
	 uint8_t tempo_read = 0;
	 uint8_t sensor_read_prev = 0; 
	 
   /* initialize the system by prescaling the system clock, disable JTAG pins */
    init_system();

    /* configure timer ISR to fire every 50msec */
    init_timer_isr();

	/* Initialize Touch sensors */
	touch_init();
  
	/* Initialize the UART */
	uart_init();
	
	FILE uart_output = FDEV_SETUP_STREAM(uart_putchar, NULL, _FDEV_SETUP_WRITE);
	FILE uart_input = FDEV_SETUP_STREAM(NULL, uart_getchar, _FDEV_SETUP_READ);

	stdout = &uart_output;
	stdin  = &uart_input;

	fprintf (stdout,"Tempo and Volume connection check...\n");
	
    /* Infinite loop */
    for( ; ; )
    {
		touch_measure();
// 		if ((count1>40)&&(count1<80))
// 		{
// 			PORTD|=(1<<PORTD2); // turn on the LED
// 			goto Z;
// 		}
// 		if (count1>80)
// 		{
// 			PORTD&=~(1<<PORTD2);
// 			count1=0;
// 		}
 		if (GET_SENSOR_STATE(2))
		{
		//	vol_leds = 0;
			tempo_read = GET_ROTOR_SLIDER_POSITION(1);
			
			if (tempo_read > tempo_prev)
			{
				if( (tempo_read - tempo_prev) > 10)
				{
					tempo_prev = tempo;
					tempo = tempo_read;
				}
			}	
			if(tempo_read <= tempo_prev)
			{
				if((tempo_prev - tempo_read) > 10)
				{
					tempo_prev = tempo;
					tempo = tempo_read;
				}
			}	
			
			if (tempo <= 16) tempo_leds=1;
			else if ((tempo > 16) && (tempo <= 32)) tempo_leds=2;			 
			else if ((tempo > 32) && (tempo <= 48)) tempo_leds=3;
			else if ((tempo > 48) && (tempo <= 64)) tempo_leds=4;
			else if ((tempo > 64) && (tempo <= 80)) tempo_leds=5;
			else if ((tempo > 80) && (tempo <= 96)) tempo_leds=6;
			else if ((tempo > 96) && (tempo <= 112)) tempo_leds=7;
			else if ((tempo > 112) && (tempo <= 128)) tempo_leds=8;			
			else if ((tempo > 128) && (tempo <= 144)) tempo_leds=9;
			else if ((tempo > 144) && (tempo <= 160)) tempo_leds=10;
			else if ((tempo > 160) && (tempo <= 176)) tempo_leds=11;
			else if ((tempo > 176) && (tempo <= 192)) tempo_leds=12;
			else if ((tempo > 192) && (tempo <= 208)) tempo_leds=13;
			else if ((tempo > 208) && (tempo <= 224)) tempo_leds=14;
			else if ((tempo > 224) && (tempo <= 240)) tempo_leds=15;
			else tempo_leds=0;
// 			if (tempo_led_old!=tempo_leds)
// 			{
// 				count1=0;
// 			}
// 			tempo_led_old=tempo_leds;
// 				
		}	
		
	//	Z:		
		if (GET_SENSOR_STATE(0))
		{
		//	tempo_leds = 0;
			sensor_read = GET_ROTOR_SLIDER_POSITION(0);
			if ((sensor_read - sensor_read_prev)>10)
			{
					volume = (int) ((float)( sensor_read - 80 )*1.43);				
					sensor_read_prev = sensor_read;
			}
			if((sensor_read_prev - sensor_read)>10)
			{
					volume = (int) ((float)( sensor_read - 80 )*1.43);							
					sensor_read_prev = sensor_read;
			}

			/*if (volume <= 32) vol_leds=1;
			else if ((volume > 32) && (volume <= 64)) vol_leds=2;
			else if ((volume > 64) && (volume <= 96)) vol_leds=3;
			else if ((volume > 96) && (volume <= 128)) vol_leds=4;
			else if ((volume > 128) && (volume <= 160)) vol_leds=5;
			else if ((volume > 160) && (volume <= 192)) vol_leds=6;
			else if ((volume > 192) && (volume <= 224)) vol_leds=7;
			else if ((volume > 224) && (volume <= 256)) vol_leds=8;
			else vol_leds=0;*/
			if (volume <= 70) vol_leds=1;
			else if ((volume > 70) && (volume <= 80)) vol_leds=2;
			else if ((volume > 80) && (volume <= 130)) vol_leds=3;
			else if ((volume > 130) && (volume <= 170)) vol_leds=4;
			else if ((volume > 170) && (volume <= 200)) vol_leds=5;
			else if ((volume > 200) && (volume <= 230)) vol_leds=6;
			else if ((volume > 230) && (volume < 250)) vol_leds=7;
			else if ((volume >= 250) && (volume <= 256)) vol_leds=8;
			else vol_leds=0;
		}
			
		if ((tempo_leds)&&(state <= tempo_leds))
		{
			
			PORTC=ledA[state-1];
			PORTC|=ledB[(state1-1)];
			state++;
			if (state==16)
			{
				state = 1;
			}
					
			_delay_ms(15);
					
		}
		else state = 1;
			
		if ((vol_leds)&&(state1 <= vol_leds))
		{
			PORTC=ledB[state1-1];
			PORTC|=ledA[(state-1)];
			state1++;
			if (state1==16)
			{
				state1 = 1;
			}
		}
		else state1 = 1;
		
		// Send Tempo and Volume (alternately) periodically to the MIDI microcontroller
		if(send_time == 0)
		{
			sendMessages();
			send_time = ST;
		}
	}	
}


void sendMessages()
{
	
	//TEMPO
	if(send_switch == SEND_TEMPO)
	{
		loop_until_bit_is_set (UCSR0A, UDRE0);
		UDR0 = TEMPO_ID;
		loop_until_bit_is_set (UCSR0A, UDRE0);
		UDR0 = tempo;
		send_switch = SEND_VOLUME;
	}
	else 
	{
		//VOLUME
		loop_until_bit_is_set (UCSR0A, UDRE0);
		UDR0 = VOLUME_ID;
		loop_until_bit_is_set (UCSR0A, UDRE0);
		UDR0 = volume;
		send_switch = SEND_TEMPO;
	}	
}
	